#include <bits/stdc++.h>
using namespace std;
void addEdge(vector<int> adj[], int u, int v)
{
    adj[u].push_back(v);
    adj[v].push_back(u);
}
bool BFS(vector<int> adj[], int src, int dest, int v,
    int pred[], int dist[])
{
    list<int> queue;
    bool visited[50000];
    for (int i = 0; i < v; i++) {
        visited[i] = false;
        dist[i] = INT_MAX;
        pred[i] = -1;
    }
    visited[src] = true;
    dist[src] = 0;
    queue.push_back(src);
    while (!queue.empty()) {
        int u = queue.front();
        queue.pop_front();
        for (int i = 0; i < adj[u].size(); i++) {
            if (visited[adj[u][i]] == false) {
                visited[adj[u][i]] = true;
                dist[adj[u][i]] = dist[u] + 1;
                pred[adj[u][i]] = u;
                queue.push_back(adj[u][i]);
                if (adj[u][i] == dest)
                    return true;
            }
        }
    }

    return false;
}
int printShortestDistance(vector<int> adj[], int s,
    int dest, int v)
{
    int pred[50000], dist[50000];

    if (BFS(adj, s, dest, v, pred, dist) == false) {
        return 0;
    }
    vector<int> path;
    int crawl = dest;
    path.push_back(crawl);
    while (pred[crawl] != -1) {
        path.push_back(pred[crawl]);
        crawl = pred[crawl];
    }
    return dist[dest];
}
int resiproblem(vector<int> adj[], int V, int a[]) {
    int br = 0;
    int min = INT_MAX;
    int minindeks = 0;
    for (size_t i = 1; i <= V; i++)
    {
        br = 0;
        for (size_t j = 1; j <= V; j++)
        {
            br += a[j] * printShortestDistance(adj, i, j, V + 1);
        }
        if (br < min) { min = br; minindeks = i; }
    }
    return minindeks;
}
int main()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0); cout.tie(0);
    int V;
    cin >> V;
    vector<int> adj[50000]; int x, y;
    for (size_t i = 1; i < V; i++)
    {
        cin >> x >> y;
        addEdge(adj, x, y);
    }
    int a[10000];
    for (size_t i = 1; i <= V; i++)
    {
        cin >> a[i];
    }
    cout << resiproblem(adj, V, a) << "\n";
    int q;
    cin >> q;
    int p, l;
    for (size_t i = 0; i < q; i++)
    {
        cin >> p >> l;
        a[l] += p;
        cout << resiproblem(adj, V, a) << "\n";
    }

    return 0;
}